<?
class Cart {
	var $items;
	var $total;

	function Cart() {

		$this->init();
	}

	function init() {

		$this->items = array();
		$this->total = 0;
	}

	function add(&$productid, $qty) {

		if (isset($productid)) {
			setdefault($this->items[$productid], 0);
			$this->items[$productid] += $qty;
		}
	}

	function set(&$productid, $qty) {

		if (isset($productid)) {
			$this->items[$productid] = (int) $qty;
		}
	}

	function remove(&$productid) {

		if (isset($productid)) {
			unset($this->items[$productid]);
		}
	}

	function cleanup() {

		foreach ($this->items as $productid => $qty) {
			if ($qty < 1) {
				unset($this->items[$productid]);
			}
		}
	}

	function itemcount() {

		$count = 0;
		foreach ($this->items as $productid => $qty) {
			$count += $qty;
		}

		return $count;
	}

	function get_productid_list() {

		$productid_list = "";

		foreach ($this->items as $productid => $qty) {
			$productid_list .= ",'" . $productid . "'";
		}

		return substr($productid_list, 1);
	}

	function recalc_total() {

		$this->total = 0;

		$in_clause = $this->get_productid_list();
		if (empty($in_clause)) {
			return;
		}

		$qid = db_query("SELECT id, price FROM products WHERE id IN ($in_clause)");
		while ($product = db_fetch_object($qid)) {
			$this->total += $this->items[$product->id] * $product->price;
		}
	}
}

?>